<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Partner extends Model 
{

    protected $table = 'partners';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function projects()
    {
        return $this->belongsToMany('App\Models\Project', 'project_partner', 'partner_id', 'project_id');
    }

}